﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProviderCredentialsController : ODataController
    {
        public async Task<HttpResponseMessage> Get([FromODataUri] int key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderCredential =
                    context.ppms_providercredentialSet.FirstOrDefault(x => x.ppms_credentialnumber == key);
                if (ppmsProviderCredential != null)
                {
                    var ppmsProviderCredentialsList = new List<ppms_providercredential> { ppmsProviderCredential };
                    var providerCredential = await ProviderCredentialsMap.MapProviderCredentials(ppmsProviderCredentialsList, queryType, context);
                    return Request.CreateResponse(providerCredential);
                }
                var message = string.Format("Provider Credential with Credential Number: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        //Returns only the Provider's related Specialties       
        [ODataRoute("ProviderCredentials({key})/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderCredential =
                    context.ppms_providercredentialSet.FirstOrDefault(x => x.ppms_credentialnumber == key);
                if (ppmsProviderCredential != null)
                {
                    //Retrieve and Return the related Provider
                    var ppmsProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderCredential.ppms_ProviderId.Id);
                    var ppmsProvidersList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(provider);
                }
                var message = string.Format("Provider with Provider Credential Number: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [ODataRoute("ProviderCredentials")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderCredentials = context.ppms_providercredentialSet.Where(i => i.ppms_credentialnumber != null).Take(50);
                var ppmsProviderCredentialList = ppmsProviderCredentials.ToList();
                if (ppmsProviderCredentialList.Any())
                {
                    //Map Providers
                    var providerCredentials = await ProviderCredentialsMap.MapProviderCredentials(ppmsProviderCredentialList, "None", context);
                    return Request.CreateResponse(providerCredentials);
                }
                var message = "Provider Credentials Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

    }
}